//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiDelegateBase {
    id : delegate

    property color pressedColor : UiColors.getColor(UiColors.SelectionGreen)
    property color hoveredColor : UiColors.getColor(UiColors.HoverGreen)
    property color disabledColor : UiColors.getColor(
                                       UiColors.DisabledLightGrey17)
    property color defocusedColor : UiColors.getColor(
                                        UiColors.InactiveSelectionGreen)

    implicitWidth  : 100
    implicitHeight : 100

    states : [
        State {
            name : "disabled"
            when : !enabled && active

            PropertyChanges {
                target  : delegate
                __color : disabledColor
            }
        },
        State {
            name : "defocused"
            when : delegate.active && delegate.defocused

            PropertyChanges {
                target  : delegate
                __color : defocusedColor
            }
        },
        State {
            name : "pressed"
            when : delegate.pressed || delegate.active

            PropertyChanges {
                target  : delegate
                __color : pressedColor
            }
        },
        State {
            name : "hovered"
            when : delegate.hovered

            PropertyChanges {
                target  : delegate
                __color : hoveredColor
            }
        }
    ]

    transitions : Transition {
        ColorAnimation {
            property : "__color"
            duration : 100
        }
    }
}
